// ZenTabCtrl.cpp : implementation file
//

#include "stdafx.h"
#include "ZenTabCtrl.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CZenTabCtrl

CZenTabCtrl::CZenTabCtrl()
{
m_CurrentPage = -1;
}

CZenTabCtrl::~CZenTabCtrl()
{
}


BEGIN_MESSAGE_MAP(CZenTabCtrl, CTabCtrl)
	//{{AFX_MSG_MAP(CZenTabCtrl)
	ON_NOTIFY_REFLECT(TCN_SELCHANGING, OnSelchanging)
	ON_NOTIFY_REFLECT(TCN_SELCHANGE, OnSelchange)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CZenTabCtrl message handlers

bool CZenTabCtrl::AddPage(CWnd *PageDialog, LPCTSTR TabCaption)
{
if (PageDialog)
    {
    ::SetWindowLong (PageDialog->m_hWnd, GWL_STYLE, WS_CHILD);
    PageDialog->SetParent (this);
    CRect Rect;
    GetClientRect (&Rect);
    AdjustRect (FALSE, &Rect);
    PageDialog->MoveWindow (&Rect);
    };
int PageIndex = m_Pages.GetSize();
m_Pages.Add(PageDialog);
InsertItem (PageIndex, TabCaption);
return (true);
}

void CZenTabCtrl::OnSelchanging(NMHDR* pNMHDR, LRESULT* pResult) 
{
ShowCurrentPage (-1);
*pResult = 0;
}

void CZenTabCtrl::OnSelchange(NMHDR* pNMHDR, LRESULT* pResult) 
{
ShowCurrentPage (GetCurSel());
*pResult = 0;
}

void CZenTabCtrl::ShowCurrentPage(int PageIndex)
{
if (m_CurrentPage >= 0)
    {
    CWnd *CurrDlg = m_Pages [m_CurrentPage];
    if (CurrDlg)
        {
        CurrDlg->ShowWindow (SW_HIDE);
        };
    };
m_CurrentPage = PageIndex;
if (m_CurrentPage >= 0)
    {
    CWnd *CurrDlg = m_Pages [m_CurrentPage];
    if (CurrDlg)
        {
        CRect Rect;
        GetClientRect (&Rect);
        AdjustRect (FALSE, &Rect);
        CurrDlg->MoveWindow (&Rect);
        CurrDlg->ShowWindow (SW_SHOW);
        };
    };
}

void CZenTabCtrl::SetCurSel(int PageIndex)
{
if (m_CurrentPage != PageIndex)
    {
    ShowCurrentPage (-1);
    CTabCtrl::SetCurSel(PageIndex);
    ShowCurrentPage (PageIndex);
    };
}

CWnd* CZenTabCtrl::GetPage(int PageIndex)
{
return (m_Pages [PageIndex]);
}

CWnd* CZenTabCtrl::ReplacePage(int PageIndex, CWnd *NewDlg)
{
CWnd* Result = GetPage (PageIndex);
if (Result != NewDlg)
    {
    m_Pages [PageIndex] = NewDlg;
    if (NewDlg)
        {
        NewDlg->SetParent (this);
        ::SetWindowLong (NewDlg->m_hWnd, GWL_STYLE, WS_CHILD);
        CRect Rect;
        GetClientRect (&Rect);
        AdjustRect (FALSE, &Rect);
        NewDlg->MoveWindow (&Rect);
        if (PageIndex == m_CurrentPage)
            {
            NewDlg->ShowWindow (SW_SHOW);
            }
        else
            {
            NewDlg->ShowWindow (SW_HIDE);
            };
        };
    };
return (Result);
}
